/*
 * TraceDaemon.h
 *
 * Copyright (C) 1999, 2000 Karim Yaghmour.
 *
 * This is distributed under GPL.
 *
 * Header for trace toolkit.
 *
 * History : 
 *    K.Y., 01/10/1999, Initial typing.
 *
 */

#ifndef __TRACE_DAEMON_MAIN_HEADER__
#define __TRACE_DAEMON_MAIN_HEADER__

#include <sys/time.h>
#include <sys/types.h>

/* Logic values */
#define FALSE 0
#define TRUE  1

/* The different events */
#define TRACE_START           0    /* This is to mark the trace's start */
#define TRACE_SYSCALL_ENTRY   1    /* Entry in a given system call */
#define TRACE_SYSCALL_EXIT    2    /* Exit from a given system call */
#define TRACE_TRAP_ENTRY      3    /* Entry in a trap */
#define TRACE_TRAP_EXIT       4    /* Exit from a trap */
#define TRACE_IRQ_ENTRY       5    /* Entry in an irq */
#define TRACE_IRQ_EXIT        6    /* Exit from an irq */
#define TRACE_SCHEDCHANGE     7    /* Scheduling change */
#define TRACE_KERNEL_TIMER    8    /* The kernel timer routine has been called */
#define TRACE_BOTTOM_HALF     9    /* Going to run a bottom half */
#define TRACE_PROCESS        10    /* Hit key part of process management */
#define TRACE_FILE_SYSTEM    11    /* Hit key part of file system */
#define TRACE_TIMER          12    /* Hit key part of timer management */
#define TRACE_MEMORY         13    /* Hit key part of memory management */
#define TRACE_SOCKET         14    /* Hit key part of socket communication */
#define TRACE_IPC            15    /* Hit key part of inter-process communication */
#define TRACE_NETWORK        16    /* Hit key part of network communication */

/* Number of traced events */
#define TRACE_MAX            TRACE_NETWORK

/* The configurations possible */
#define TRACER_START                      0  /* Start tracing events using the current configuration */
#define TRACER_STOP                       1  /* Stop tracing */
#define TRACER_CONFIG_DEFAULT             2  /* Set the tracer to the default configuration */
#define TRACER_CONFIG_MEMORY_BUFFERS      3  /* Set the memory buffers the daemon wants us to use */
#define TRACER_CONFIG_EVENTS              4  /* Trace the given events */
#define TRACER_CONFIG_DETAILS             5  /* Record the details of the event, or not */
#define TRACER_CONFIG_CPUID               6  /* Record the CPUID associated with the event */
#define TRACER_CONFIG_PID                 7  /* Trace only one process */
#define TRACER_CONFIG_PGRP                8  /* Trace only the given process group */
#define TRACER_CONFIG_GID                 9  /* Trace the processes of a given group of users */
#define TRACER_CONFIG_UID                10  /* Trace the processes of a given user */
#define TRACER_CONFIG_SYSCALL_EIP_DEPTH  11  /* Set the call depth at which the EIP should be fetched on syscall */
#define TRACER_CONFIG_SYSCALL_EIP_LOWER  12  /* Set the lowerbound address from which EIP is recorded on syscall */
#define TRACER_CONFIG_SYSCALL_EIP_UPPER  13  /* Set the upperbound address from which EIP is recorded on syscall */
#define TRACER_DATA_COMITTED             14  /* The daemon has comitted the last trace */
#define TRACER_GET_EVENTS_LOST           15  /* Get the number of events lost */

/* The event mask functions and definitions */
typedef uint32_t tracer_event_mask;

/* The information required to configure the memory regions used to log events */
typedef struct _trace_memory_regions
{
  uint32_t           RegionSize;           /* Size of the memory sizes */
  uint32_t           PrimaryRegion;        /* Primary memory region */
  uint32_t           SecondaryRegion;      /* Secondary memory region */
} trace_memory_regions;

/* Options structure */
typedef struct _options
{
  int                ConfigDefault;      /* Use the tracing device's default configuration */
  int                SpecifyEvents;      /* Does the user want to specify the events to trace */
  tracer_event_mask  EventMask;          /* The mask specifying the events to be traced */
  int                SpecifyDetails;     /* Does the user want to specify for which events he wants the details */
  tracer_event_mask  DetailsMask;        /* The mask specifying for which events the details are logged */
  int                ConfigCPUID;        /* Should the CPUID be logged */
  int                ConfigPID;          /* Does the user want to log only the events belonging to a certain PID */
  int                PID;                /* The designated PID */
  int                ConfigPGRP;         /* Does the user want to log only the events belonging to a certain process group */
  int                PGRP;               /* The designated process group */
  int                ConfigGID;          /* Does the user want to log only the events belonging to a certain GID */
  int                GID;                /* The designated GID */
  int                ConfigUID;          /* Does the user want to log only the events belonging to a certain UID */
  int                UID;                /* The designated UID */
  int                ConfigSyscallDepth; /* Fetch a certain syscall depth */
  int                SyscallDepth;       /* The designated depth */
  int                ConfigSyscallBound; /* Fetch the syscall eip that fits in a certain address bounds */
  uint32_t           UpperBound;         /* The upper bound eip */
  uint32_t           LowerBound;         /* The lower bound eip */
  int                ConfigTime;         /* Should the deamon only run for a given period of time */
  struct timeval     Time;               /* Time for which daemon should run */
  char*              DeviceFileName;     /* The name of the device from which to read events */
  char*              TraceFileName;      /* Name of file used to dump raw trace */
  char*              ProcFileName;       /* Name of file contaning /proc information as of daemon's startup */
} options;

#endif  /* __TRACE_DAEMON_MAIN_HEADER__ */
