/*
 * DumpToFile.h
 *
 * Copyright (C) 1999 Jean-Hugues Deschenes.
 *
 * This is distributed under GPL.
 *
 * Header for dump to file window.
 *
 * History : 
 *    K.Y., 23/06/1999, Initial typing.
 *
 * Note : The current version of this toolkit is for linux 2.2.0.
 */

#ifndef __TRACE_TOOLKIT_DUMP_TO_FILE__
#define __TRACE_TOOLKIT_DUMP_TO_FILE__

/* Define object data keys */
#define OPT_MENU_DATA   "Process pointer" /* Process pointer for option menu items */
#define EVENT_TYPE_DATA "Event type ID"   /* index to the event type in the omit/trace array */

#include "TraceToolkit.h"
#include <gtk/gtk.h>

/* Define what the OK and Cancel callbacks look like */
typedef void _DTFCBCancel
         (gpointer  /* The system view */);
typedef void _DTFCBOK
         (gpointer  /* The system view */);

/* Trace file selection window */
typedef struct _dumpToFileWindow
{
  /* The data */
  gpointer      SysView;            /* system view */
  GtkWidget*    ParentWin;          /* Parent window */
  _DTFCBOK*     CBOK;   
  _DTFCBCancel* CBCancel;
  options*      LocalOptions;       /* Local copy of the options to configure */

  /* The widgets */
  GtkWidget*    Window;             /* Window to choose files */

  GtkWidget*    VBox;               /* Main vertical box */

  GtkWidget*    Notebook;           /* The main notebook */

  GtkWidget*    ProcessTable;       /* The process selection packing table */
  GtkWidget*    EventsVBox;         /* The event selection VBox */
  GtkWidget*    SMPTable;           /* The SMP options packing table */
  GtkWidget*    OptionsVBox;        /* The miscellaneous options VBox */

  GtkWidget*    FileHBox;           /* Horizontal box containing text and browse button for dump file */
  GtkWidget*    ButtonHBox;         /* Box containing OKButton and CancelButton */

  GtkWidget*    FileLabel;          /* Label asking for dump file */

  GtkWidget*    FileTextEntry;      /* Where dump file name is displayed */

  GtkWidget*    FileBrowse;         /* Button to browse for dump file */

  GtkWidget*    FileSelect;         /* The window where the dump file is to be selected */

  GSList*       ProcRadioGroup;     /* The process radio buttons group */
  GtkWidget*    TraceAllProc;       /* "Trace all processes" radio button */
  GtkWidget*    JustThisProc;       /* "Just this process" radio button */
  GtkWidget*    Proclist;           /* The process list option menu */
  GtkWidget*    ProcListMenu;       /* The process list itself */

  GtkWidget*    PrintEvents;        /* The "Print events" check button */
  GtkWidget*    SelectEventFrame;   /* The event selection frame */
  GtkWidget*    SelectEventVBox;    /* The event selection VBox */
  GSList*       EventRadioGroup;    /* The events radio button group */
  GtkWidget*    TraceAllEvents;     /* "Trace all events" radio button */
  GtkWidget*    TraceTheseEvents;   /* "Trace these events: " radio button */
  GtkWidget*    OmitTheseEvents;    /* "Omit these events: " radio button */
  GtkWidget*    ScrolledEventList;  /* Scroll window for the event list */
  GtkWidget*    EventList;          /* Event list for event selection/omission */

  GSList*       SMPRadioGroup;      /* The SMP radio buttons group */
  GtkWidget*    TraceAllCPUs;       /* "Trace all CPUs" radio button */
  GtkWidget*    JustThisCPU;        /* "Just this CPU" radio button */
  GtkWidget*    CPUIDEntry;         /* The process list itself */

  GtkWidget*    AccountSysCalls;    /* "Account time spent in system calls" check button */
  GtkWidget*    ForgetTime;         /* "Don't print time" check button */
  GtkWidget*    ForgetString;       /* "Don't print description string" check button */
  GtkWidget*    ForgetDataLen;      /* "Don't print length of data entry" check button */
  GtkWidget*    ForgetPID;          /* "Don't print PIDs" check button */
  GtkWidget*    ForgetCPUID;        /* "Don't print CPUIDs" check button */

  GtkWidget*    OKButton;           /* OK Button */
  GtkWidget*    CancelButton;       /* Cancel Button */

} dumpToFileWindow;

/* Function prototypes */
void              DTFConnectSignals
                      (dumpToFileWindow* /* The dump to file window */);

void              DTFShowDumpToFileWindow
                      (dumpToFileWindow* /* The dump to file window */);

dumpToFileWindow* DTFCreateDumpToFileWindow
		      (gpointer          /* The system view */,
		       GtkWidget*        /* The parent window */,
                       _DTFCBOK*         /* Function to call in case of OK */,
		       _DTFCBCancel*     /* Function to call in case of cancel or close */);

void              DTFDestroyDumpToFileWindow
                      (dumpToFileWindow* /* The dump to file window */);


#endif /* __TRACE_TOOLKIT_DUMP_TO_FILE__ */

