/*
 * EventGraph.h
 *
 * Copyright (C) 1999 Karim Yaghmour.
 *
 * This is distributed under GPL.
 *
 * Header for event graph engine.
 *
 * History : 
 *    K.Y., 28/06/99, Initial typing.
 */

#ifndef __TRACE_TOOLKIT_EVENT_GRAPH__
#define __TRACE_TOOLKIT_EVENT_GRAPH__

#include "EventDB.h"
#include "Pixmap.h"
#include <gtk/gtk.h>

#define EGRAPH_PIX_START           20
#define EGRAPH_USEC_PER_PIX       100      /* Number of micro-seconds to display per pixel */
#define EGRAPH_USEC_PER_PIX_MIN  0.01      /* Minimun number of micro-seconds to display per pixel */
#define EGRAPH_USEC_PER_PIX_MAX 10000      /* Maximum number of micro-seconds to display per pixel */
#define EGRAPH_ZOOM_IN_FACTOR       2      /* Factor by which number of usec/pix is divided */
#define EGRAPH_ZOOM_OUT_FACTOR      2      /* Factor by which number of usec/pix is multiplied */
#define EGRAPH_TEXT_TO_LINE_DIST    3      /* Distance between line and text */
#define EGRAPH_ICONS_WIDTH         16      /* The width of a system event icon */
#define EGRAPH_ICONS_HEIGHT        16      /* The height of a system event icon */

/* Structure defining position and associated event fon an event icon */
/* Required to memorize event position, required when right-clicking */
typedef struct _EventIconArea
{
  guint  x;               /* x coordinate of the associated event icon */
  guint  y;               /* y coordinate of the associated event icon */
  event  AssociatedEvent; /* Pointer to the associated event descriptor structure */
}EventIconArea;

/* Structure that fully defines a clipped pixmap */
typedef struct _PixAndMask
{
  GdkPixmap* Pixmap;    /* The pixmap itself */
  GdkBitmap* Mask;      /* The pixmap's clipping mask */
}PixAndMask;

/* The event graph widget */
typedef struct _eventGraph
{
  /* Widget state */
  gboolean      Init;           /* Is the event finished initializing */
  gboolean      ColorsAllocated;/* Have the colors been allocated */
  gboolean      CreatedItemsGC; /* Have the Items' Graphic contexts been created */
  gboolean      ShowHorizon;    /* Show horizon lines */

  /* The data */
  db*           EventDB;        /* The event database drawn */
  system*       System;         /* The system who's trace is drawn */
  gpointer      MainWindow;     /* The main window this event graph belongs to */
  process*      SelectedProc;   /* The currently selected process */

  /* The gtk  widgets */
  GtkWidget*    HPanned;        /* Horizontal panned widget */
  GtkWidget*    ProcVBox;       /* VBox to contain process stuff */
  GtkWidget*    DrawVBox;       /* VBox to contain drawing stuff */
  GtkWidget*    DummyBox;       /* This is to have the right spacing */

  GtkWidget*    ScrolledList;   /* Window containing scrollable list */
  GtkWidget*    List;           /* List of processes */

  GtkWidget*    HRuler;         /* Horizontal ruler */
  GtkWidget*    ScrolledDraw;   /* Window containing scrollable draw area */
  GtkWidget*    DrawArea;       /* Area where graph is drawn */
  GtkObject*    HAdjustment;    /* Horizontal adjustment */
  GtkWidget*    HScrollBar;     /* Scrollbar to scroll around the draw area */

  /* The gdk objects */
  GdkPixmap*    PixMap;         /* Pixmap where trace is drawn */
  GdkFont*      TextFont;       /* The text font used to draw text */
  GdkColor*     RedColor;       /* The colors themselves */
  GdkColor*     BlueColor; 
  GdkColor*     GreyColor;
  GdkColor*     GreenColor; 
  GdkColor*     BlackColor; 
  GdkColor*     WhiteColor;
  GdkColor*     OrangeColor;
  GdkColor*     YellowColor;
  GdkColor*     TurquoiseColor;
  GdkColor*     PurpleColor;

  /* The colors for each type of line */
  GdkGC*        BackgroundGC;   /* The background color */
  GdkGC*        HorizonGC;      /* Mark the horizontal horizon for every process to ease view */
  GdkGC*        ProcessGC;      /* Time in process */
  GdkGC*        Process0GC;     /* Time in process 0 */
  GdkGC*        KernelGC;       /* Time in kernel  */
  GdkGC*        SelectedGC;     /* Line drawn across the selected event */
  GdkGC*        SysCallGC;      /* Transition due to syscall entry or exit */
  GdkGC*        TrapGC;         /* Transition due to trap entry or exit */
  GdkGC*        InterruptGC;    /* Transition due to interrupt */
  GdkGC*        TextGC;         /* Text color */

  /* Drawing information */
  guint         NbProc;         /* Number of processes in trace */
  guint         LabelHeight;    /* Height of the labels of the processes */
  guint         PixStart;       /* Number of pixels to put before first displayed event */
  guint         PixPerUSec;     /* Number of pixels per microsecond */
  gfloat        USecPerPix;     /* Number of microsecond per pixel */
  gulong        HTrueSize;      /* Horizontal true size */
  gulong        VTrueSize;      /* Vertical true size */
  guint         HDrawSize;      /* Horizontal draw size */
  guint         VDrawSize;      /* Vertical draw size */
  gdouble       StartTime;      /* Start time of trace */
  gdouble       Duration;       /* Duration of trace */
  gdouble       Interval;       /* Time interval drawable per scroll page */
  GList*        EventIconPos;   /* List of the coordinates of the event icons */

  /* Scroll information */
  event         DrawStartEvent; /* First event to be drawn */
  event         DrawEndEvent;   /* Last event to be drawn */
  gdouble       DrawStartTime;  /* Time of first event to be drawn */
  gfloat        LastScrollVal;  /* Latest scroll position */

  /* Cached icons */
  PixAndMask    KernelTimer;    /* The "Kernel Timer" icon */
  PixAndMask    SysCall;        /* The "System Call" icon */
  PixAndMask    Trap;           /* The "Trap" icon*/
  PixAndMask    SchedChange;    /* The "Schedule change" icon */
  PixAndMask    BottomHalf;     /* The "Bottom Half" icon */
  PixAndMask    IOStart;        /* The "I/O Start" icon */
  PixAndMask    IOEnd;          /* The "I/O End" icon */
  PixAndMask    IRQ;            /* The "IRQ" icon */
} eventGraph;

/* Functions */
gboolean    EGMouseOnIcon
              (gint           /* The mouse's x coordinate */,
	       gint           /* The mouse's y coordinate */,
	       EventIconArea* /* The Icon to check for */);
void        EGZoomIn
              (eventGraph*    /* The event graph where we should zoom in */);
void        EGZoomOut
              (eventGraph*    /* The event graph where we should zoom out */);
void        EGScrollToEvent
              (eventGraph*    /* The event graph where we should adjust the position */,
	       event*         /* The event to scroll to */);
void        EGISetHorizonView
              (eventGraph*    /* Event graph who's horizon is to be set */);
void        EGConnectSignals
              (eventGraph*    /* The event graph who's signals are to be connected */);
void        EGShowEventGraph
              (eventGraph*    /* The graph to display */);
eventGraph* EGCreateEventGraph
              (gpointer       /* Main window to which event graph belongs */);
void        EGDestroyEventGraph
              (eventGraph**   /* the event graph pointer's adress*/);
void        EGDisplayEventTrace
              (eventGraph*    /* The graph who's trace should be drawn */,
	       system*        /* System being drawn */,
	       db*            /* Database of events */);
void        EGClearEventGraph
              (eventGraph*    /* Event graph to be cleared */);
#endif /*  __TRACE_TOOLKIT_EVENT_GRAPH__ */
