/*
 * MainWindow.h
 *
 * Copyright (C) 1999 Karim Yaghmour, Jean-Hugues Deschenes.
 *
 * This is distributed under GPL.
 *
 * Header for main window of trace toolkit.
 *
 * History : 
 *    JH.D., 07/08/1999, Added Toolbar to interface
 *    K.Y., 26/06/1999, Renamed file.
 *    K.Y., 02/06/1999, Initial typing.
 */

#ifndef __TRACE_TOOLKIT_MAIN_WINDOW__
#define __TRACE_TOOLKIT_MAIN_WINDOW__

/* Basic includes */
#include "TraceToolkit.h"
#include "EventDB.h"

/* Includes necessary for graphic front-end */
#if GTK_ENV
#include <gtk/gtk.h>
#include "OpenTrace.h"
#include "EventGraph.h"
#include "ColorSelect.h"
#include "ViewTime.h"
#include "GotoEvent.h"
#include "DumpToFile.h"

/* String to identify tree item data */
#define TREE_ITEM_DATA_PROC "Process poointer" /* Pointer to a process object */

#define HELP_CONTENTS_TEXT \
"The help files can be found under\n \
the /Help directory of the LTT source directory."

#define ABOUT_BOX_TEXT \
"Linux Trace Toolkit\n\n \
Version 0.9.1 \n \
(C) 1999, 2000 \n\n \
Karim Yaghmour (karym@opersys.com)\n \
Jean-Hugues Deschenes (mr.max@vl.videotron.ca)"

/* Structure describing a trace main window */
typedef struct _mainWindow
{
  /* Main widgets */
  GtkWidget*    MWindow;            /* Main window */
  GtkWidget*    MVBox;              /* Main VBox */
  GtkWidget*    MMenu;              /* Main menu */
  GtkWidget*    MNotebook;          /* Main Notebook */
  GtkWidget*    MStatusBar;         /* Status bar */
  GtkWidget*    MToolBar;           /* Toolbar */

  /* Status bar information */
  guint         StatBarContextID;   /* Context ID of status bar */
  guint         StatBarLastMsg;     /* Last message ID */
 
  /* Menu items on main menu */
  GtkWidget*    FileMenuTitle;      /* File menu */
  GtkWidget*    EditMenuTitle;      /* Edit menu */
  GtkWidget*    ToolsMenuTitle;     /* Tools menu */
  GtkWidget*    OptionsMenuTitle;   /* Options menu */
  GtkWidget*    TraceMenuTitle;     /* Trace menu */
  GtkWidget*    HelpMenuTitle;      /* Help menu */

  /* Submenus */
  GtkWidget*    FileMenu;           /* File menu */
  GtkWidget*    EditMenu;           /* Edit menu */
  GtkWidget*    ToolsMenu;          /* Tools menu */
  GtkWidget*    OptionsMenu;        /* Options menu */
  GtkWidget*    TraceMenu;          /* Trace menu */
  GtkWidget*    HelpMenu;           /* Help menu */

  /* File menu items */
  GtkWidget*    OpenTrace;          /* Open a trace */
  GtkWidget*    CloseTrace;         /* Close current trace trace */
  GtkWidget*    DumpToFile;         /* Dump trace to file */
  GtkWidget*    FileMenuSeparator1; /* Separator */
  GtkWidget*    Quit;               /* Quit trace session */

  /* Edit menu items */

  /* Tools menu items */
  GtkWidget*    ZoomIn;             /* Zoom in */
  GtkWidget*    ZoomOut;            /* Zoom out */
  GtkWidget*    ToolMenuSeparator1; /* Separator */
  GtkWidget*    ShowHorizon;        /* Show the horizon lines */
  GtkWidget*    ToolMenuSeparator2; /* Separator */
  GtkWidget*    ToolGoToEvent;      /* Go to event... */
  GtkWidget*    ToolViewTimeFrame;  /* View time frame */

  /* Options menu items */
  GtkWidget*    Colors;             /* Display colors */
  GtkWidget*    OptMenuSeparator1;  /* Separator */
  GtkWidget*    ConfigureDaemon;    /* Configure trace daemon */

  /* Help menu items */
  GtkWidget*    Contents;           /* Content of help */
  GtkWidget*    HelpMenuSeparator1; /* Separator */
  GtkWidget*    About;              /* About trace toolkit */

  /* Toolbar Buttons */
  GtkWidget*    tlbOpenTrace;       /* Open a trace */
  GtkWidget*    tlbCloseTrace;      /* Close current trace */
  GtkWidget*    tlbDumpFile;        /* Dump to file */
  GtkWidget*    tlbZoomIn;          /* Zoom in */
  GtkWidget*    tlbZoomOut;         /* Zoom out */
  GtkWidget*    tlbGotoEvent;       /* Go to event */
  GtkWidget*    tlbShowHorizon;     /* Show horizon */

  /* The Notebook thumbnails */
  GtkWidget*    Graph;              /* Graph view of trace */
  GtkWidget*    Process;            /* Per-process specific information */
  GtkWidget*    RawTrace;           /* Raw event trace */

  /* Graph thumbnail */
  GtkWidget*    GTHBox;             /* Horizontal box */
  eventGraph*   GTEventGraph;       /* The event graph*/

  /* Process thumbnail */
  GtkWidget*    PTHPanned;          /* Horizontal panned widget */
  GtkWidget*    PTScrolledTree;     /* Window to contain scrollable tree */
  GtkWidget*    PTProcessTree;      /* Process tree */
  GtkWidget*    PTScrolledText;     /* Window to contain scrollable text */
  GtkWidget*    PTProcessText;      /* Text describing process */
  GdkFont*      PTTextFont;         /* Font used to print process characteristics */

  /* Raw event trace */
#define RTCLIST_NB_COLUMNS 7
#define RTCLIST_NB_ROWS    50
#if 0
  gchar*        RTCListTitles[RTCLIST_NB_COLUMNS] = {"CPU-ID",
                                                     "Event",
						     "Seconds",
						     "Microseconds",
						     "PID",
						     "Entry Length",
						     "Event Description"};
#endif
  GtkWidget*     RTHBox;    /* Columned list horizontal packing box */
  GtkWidget*     RTVScroll; /* The list's scrollbar */
  GtkAdjustment* RTVAdjust; /* The scrollbar's adjustment */
  GtkWidget*     RTCList;   /* Columned list */
  

  /* Event graph popup */
  GtkWidget*    EventGraphPopup;    /* The popup menu associated to the event graph */
  GtkWidget*    EventGotoProcess;   /* Goto process analysis */
  GtkWidget*    EventViewRawEvent;  /* Go to raw event list */

  /* Raw event popup */
  GtkWidget*    RawEventPopup;      /* The popup menu associated to the raw event list */
  GtkWidget*    RawViewEvent;       /* View event in graph */
  GtkWidget*    RawGotoProcess;     /* Goto process analysis */

  /* Child windows */
  openTraceWindow*     OpenTraceWindow;     /* Window used to get a prof and a proc file */
  colorSelectWindow*   ColorSelectWindow;   /* Window used to configure colors and linetypes */
  viewTimeFrameWindow* ViewTimeFrameWindow; /* Window used to select a time frame to be viewed */
  gotoEventWindow*     GotoEventWindow;     /* Window used to search for an event description */
  dumpToFileWindow*    DumpToFileWindow;    /* Window used to set file dumping options */
  GtkWidget*           HelpContents;        /* Window used to display help contents */
  GtkWidget*           AboutBox;            /* Window used for about information */

  /* Last selected event, required by context menus */
  int           EventSelected;
  event         LastSelectedEvent;

} mainWindow;

/* Structure linking a trace toolkit window with a system description */
typedef struct _systemView
{
  db*                 EventDB;           /* Database of events */
  system*             System;            /* System description */
  options*            Options;           /* The system options */
  mainWindow*         Window;            /* Window where information is displayed */
  struct _systemView* Next;              /* Next system view in list */
} systemView;

/* The trace window functions */
void        WDConnectSignals
                 (systemView*  /* The system view who's signals are to be connected*/);

void        WDShowMainWindow
                 (systemView*  /* Main window to be shown */);

void        WDFillEventList
                 (GtkWidget*  /* The CList to be filled */,
		  db*         /* The event database */,
		  system*     /* The system */,
		  event*      /* The first event to display in the raw event list */,
		  event*      /* Last selected event, if any */);

mainWindow* WDCreateMainWindow
                 (void);

void        WDDisplayTrace
                 (systemView*  /* The system view to be displayed */);

systemView* WDCreateSystemView
                 (system*      /* System description */,
		  db*          /* Event database */,
		  options*     /* The options for this view */);

void        WDDestroySystemView
                 (systemView*  /* The system view to destroy*/);

void        WDStatusBarDisplay
                 (gpointer     /* Main window */,
                  gchar*       /* String to be displayed */);

void        WDSetMenusSensitivity
                 (systemView*  /* The System view containing the menus to set */,
		  gboolean     /* sensitivity value to be set */);

void        WDToolBarPopulate
                 (systemView*  /* The system view to be displayed */);

#endif /* GTK_ENV */
#endif /* __TRACE_TOOLKIT_MAIN_WINDOW__ */
