/*
 * File: pixmaps.c
 * Auth: Jean-Hugues Deschenes, some icons by Eric Harlow
 *
 * Pixmaps used in toolbars and functions to handle them
 */

#include "Pixmap.h"



/*
 * CreateWidgetFromXpm
 *
 * Using the window information and the string with the icon color/data, 
 * create a widget that represents the data.  Once done, this widget can
 * be added to buttons or other container widgets.
 *
 * This function modified from CreateWidgetFromXpm (c)Eric Harlow
 */
GtkWidget *CreateWidgetFromXpm (GtkWidget *widget, gchar **xpm_data)
{
  
  GdkBitmap *mask;
  GdkPixmap *pixmap_data;
  GtkStyle  *style;
  GtkWidget *pixmap_widget;

  /* Get the pixmap from gdk */
  style = gtk_widget_get_style( widget );
  pixmap_data = gdk_pixmap_create_from_xpm_d( widget->window,  &mask,
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar **)xpm_data );

  pixmap_widget = gtk_pixmap_new (pixmap_data, mask);
  gtk_widget_show (pixmap_widget);
  
  return (pixmap_widget);
}
