/*
   Tables.c : Data tables for the Linux Trace Toolkit.
   Copyright (C) 1999 Karim Yaghmour.
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   History : 
     K.Y., 29/10/99, Initial typing.
*/

#include <linux/sys.h>  /* for NR_syscalls */
#include "MainWindow.h"
#include "Tables.h"

/* Size of event structures */
int EventStructSize[TRACE_MAX + 1] =
{
  sizeof(trace_start)             /* TRACE_START */,
  sizeof(trace_syscall_entry)     /* TRACE_SYSCALL_ENTRY */,
  0                               /* TRACE_SYSCALL_EXIT */,
  sizeof(trace_trap_entry)        /* TRACE_TRAP_ENTRY */,
  0                               /* TRACE_TRAP_EXIT */,
  sizeof(trace_irq_entry)         /* TRACE_IRQ_ENTRY */,
  0                               /* TRACE_IRQ_EXIT */,
  sizeof(trace_schedchange)       /* TRACE_SCHEDCHANGE */,
  0                               /* TRACE_KERNEL_TIMER */,
  sizeof(trace_bottom_half)       /* TRACE_BOTTOM_HALF */,
  sizeof(trace_process)           /* TRACE_PROCESS */,
  sizeof(trace_file_system)       /* TRACE_FILE_SYSTEM */,
  sizeof(trace_timer)             /* TRACE_TIMER */,
  sizeof(trace_memory)            /* TRACE_MEMORY */,
  sizeof(trace_socket)            /* TRACE_SOCKET */,
  sizeof(trace_ipc)               /* TRACE_IPC */,
  sizeof(trace_network)           /* TRACE_NETWORK */,
  sizeof(trace_buffer_start)      /* TRACE_BUFFER_START */,
  0                               /* TRACE_BUFFER_END */,
  sizeof(trace_new_event)         /* TRACE_NEW_EVENT */,
  sizeof(trace_custom)            /* TRACE_CUSTOM */
};

/* Event description strings */
char *EventID[TRACE_MAX + 1] = 
{
"Trace start",
"Syscall entry",
"Syscall exit",
"Trap entry",
"Trap exit",
"IRQ entry",
"IRQ exit",
"Sched change",
"Kernel timer",
"Bottom half",
"Process",
"File system",
"Timer",
"Memory",
"Socket",
"IPC",
"Network",
};

/* Event strings the user can specify at the command line to omit or trace */
char *EventOT[TRACE_MAX + 1] =
{
"START",
"SYS_ENTRY",
"SYS_EXIT",
"TRAP_ENTRY",
"TRAP_EXIT",
"IRQ_ENTRY",
"IRQ_EXIT",
"SCHED",
"KTIMER",
"BH",
"PROCESS",
"FS",
"TIMER",
"MEM",
"SOCKET",
"IPC",
"NET"
};

/* Number of system calls defined */
int NbSyscallsDefined = 191;

/* System call name according to it's ID */
char *SyscallID[NR_syscalls] =
{
"ni_syscall",		/* 0  -  old "setup" system call */
"exit",
"fork",
"read",
"write",
"open",			/* 5 */
"close",
"waitpid",
"creat",
"link",
"unlink",		/* 10 */
"execve",
"chdir",
"time",
"mknod",
"chmod",		/* 15 */
"lchown",
"ni_syscall",		/* old break syscall holder */
"stat",
"lseek",
"getpid",		/* 20 */
"mount",
"oldumount",
"setuid",
"getuid",
"stime",		/* 25 */
"ptrace",
"alarm",
"fstat",
"pause",
"utime",		/* 30 */
"ni_syscall",		/* old stty syscall holder */
"ni_syscall",		/* old gtty syscall holder */
"access",
"nice",
"ni_syscall",		/* 35 *//* old ftime syscall holder */
"sync",
"kill",
"rename",
"mkdir",
"rmdir",		/* 40 */
"dup",
"pipe",
"times",
"ni_syscall",		/* old prof syscall holder */
"brk",			/* 45 */
"setgid",
"getgid",
"signal",
"geteuid",
"getegid",		/* 50 */
"acct",
"umount",		/* recycled never used phys() */
"ni_syscall",		/* old lock syscall holder */
"ioctl",
"fcntl",		/* 55 */
"ni_syscall",		/* old mpx syscall holder */
"setpgid",
"ni_syscall",		/* old ulimit syscall holder */
"olduname",
"umask",		/* 60 */
"chroot",
"ustat",
"dup2",
"getppid",
"getpgrp",		/* 65 */
"setsid",
"sigaction",
"sgetmask",
"ssetmask",
"setreuid",		/* 70 */
"setregid",
"sigsuspend",
"sigpending",
"sethostname",
"setrlimit",		/* 75 */
"getrlimit",
"getrusage",
"gettimeofday",
"settimeofday",
"getgroups",		/* 80 */
"setgroups",
"old_select",
"symlink",
"lstat",
"readlink",		/* 85 */
"uselib",
"swapon",
"reboot",
"old_readdir",
"old_mmap",		/* 90 */
"munmap",
"truncate",
"ftruncate",
"fchmod",
"fchown",		/* 95 */
"getpriority",
"setpriority",
"ni_syscall",		/* old profil syscall holder */
"statfs",
"fstatfs",		/* 100 */
"ioperm",
"socketcall",
"syslog",
"setitimer",
"getitimer",		/* 105 */
"newstat",
"newlstat",
"newfstat",
"uname",
"iopl",			/* 110 */
"vhangup",
"idle",
"vm86old",
"wait4",
"swapoff",		/* 115 */
"sysinfo",
"ipc",
"fsync",
"sigreturn",
"clone",		/* 120 */
"setdomainname",
"newuname",
"modify_ldt",
"adjtimex",
"mprotect",		/* 125 */
"sigprocmask",
"create_module",
"init_module",
"delete_module",
"get_kernel_syms",	/* 130 */
"quotactl",
"getpgid",
"fchdir",
"bdflush",
"sysfs",		/* 135 */
"personality",
"ni_syscall",		/* for afs_syscall */
"setfsuid",
"setfsgid",
"llseek",		/* 140 */
"getdents",
"select",
"flock",
"msync",
"readv",		/* 145 */
"writev",
"getsid",
"fdatasync",
"sysctl",
"mlock",		/* 150 */
"munlock",
"mlockall",
"munlockall",
"sched_setparam",
"sched_getparam",	 /* 155 */
"sched_setscheduler",
"sched_getscheduler",
"sched_yield",
"sched_get_priority_max",
"sched_get_priority_min",  /* 160 */
"sched_rr_get_interval",
"nanosleep",
"mremap",
"setresuid",
"getresuid",		/* 165 */
"vm86",
"query_module",
"poll",
"nfsservctl",
"setresgid",		/* 170 */
"getresgid",
"prctl",
"rt_sigreturn",
"rt_sigaction",
"rt_sigprocmask",	/* 175 */
"rt_sigpending",
"rt_sigtimedwait",
"rt_sigqueueinfo",
"rt_sigsuspend",
"pread",		/* 180 */
"pwrite",
"chown",
"getcwd",
"capget",
"capset",		/* 185 */
"sigaltstack",
"sendfile",
"ni_syscall",		/* streams1 */
"ni_syscall",		/* streams2 */
"vfork",		/* 190 */
""
};

/* Number of traps possible */
#define NB_TRAPS   19
int NbTrapsDefined = NB_TRAPS;

/* Trap according to it's ID */
char *TrapID[NB_TRAPS] =
{
"divide error",
"debug",
"nmi",
"int3",
"overflow",
"bounds",
"invalidop",
"device notavailable",
"double fault",
"copro segment overrun",
"invalid TSS",
"segment not present",
"stack segment",
"GPF", /* most people know this one by name */
"page fault",
"spurious interrupt",
"copro error",
"alignment check",
"reserved"
};
