/*
 * ViewTime.h
 *
 * Copyright (C) 1999 Jean-Hugues Deschenes.
 *
 * This is distributed under GPL.
 *
 * Header for View time frame window.
 *
 * History : 
 *    JH.D, 11/09/1999, Initial typing.
 *
 * Note : The current version of this toolkit is for linux 2.2.0.
 */

#ifndef __TRACE_TOOLKIT_VIEW_TIME__
#define __TRACE_TOOLKIT_VIEW_TIME__

#include "TraceToolkit.h"
#if 0 /* No need for stdlib */
#include <stdlib.h>
#endif
#include <gtk/gtk.h>
#include "EventGraph.h"

/* Define what the OK and Cancel callbacks look like */
typedef void _VTFCBCancel
         (gpointer  /* The system view corresponding to this open trace */);
typedef void _VTFCBOK
         (gpointer  /* The system view corresponding to this open trace */,
	  gdouble   /* Start time of the time frame */,
	  gdouble   /* End time of the time frame */);

/* View time frame window */
typedef struct _viewTimeFrameWindow
{
  /* The data */
  gpointer      SysView;
  GtkWidget*    ParentWin;          /* Parent window */
  _VTFCBOK*     CBOK;   
  _VTFCBCancel* CBCancel;

  /* The widgets */
  GtkWidget*    Window;             /* Window to choose files */

  GtkWidget*    VBox;               /* Main vertical box */

  GtkWidget*    StartHBox;          /* Horizontal box containing label and entry for start time */
  GtkWidget*    EndHBox;            /* Horizontal box containing label and entry for end time */
  GtkWidget*    ButtonHBox;         /* Box containing OKButton and CancelButton */

  GtkWidget*    TraceTimeLabel;     /* Label to display info on the current trace */
  GtkWidget*    StartTimeLabel;     /* Label asking for start of time frame */
  GtkWidget*    EndTimeLabel;       /* Label asking for end of time frame */

  GtkWidget*    StartTimeEntry;     /* Where time frame start is entered */
  GtkWidget*    EndTimeEntry;       /* Where time frame end is entered */

  GtkWidget*    OKButton;           /* OK Button */
  GtkWidget*    CancelButton;       /* Cancel Button */
} viewTimeFrameWindow;

_VTFCBCancel VTFCBCancel;
_VTFCBOK     VTFCBOK;

/* Function prototypes */
void                 VTFConnectSignals
                      (viewTimeFrameWindow* /* The View time frame window */);
void                 VTFShowViewTimeWindow
                      (viewTimeFrameWindow* /* The View time frame window */);
viewTimeFrameWindow* VTFCreateViewTimeFrameWindow
		      (gpointer         /* The system view */,
		       GtkWidget*       /* The parent window */,
		       eventGraph*      /* The associated event graph */,
                       _VTFCBOK*        /* Function to call in case of OK */,
		       _VTFCBCancel*    /* Function to call in case of cancel or close */);
void                 VTDestroyViewTimeWindow
                      (viewTimeFrameWindow* /* The View time frame window */);


#endif /* __TRACE_TOOLKIT_OPEN_TRACE__ */

