/*
 * DevCommand.h
 *
 * Copyright (C) 2001 Karim Yaghmour.
 *
 * This is distributed under GPL.
 *
 * Header for trace device commands.
 *
 * History : 
 *    K.Y., 03/12/2001, Initial typing.
 *
 */

#ifndef __TRACE_DEV_COMMAND_HEADER__
#define __TRACE_DEV_COMMAND_HEADER__

#include <LinuxEvents.h>

/* The configurations possible */
#define TRACER_START                      TRACER_MAGIC_NUMBER + 0  /* Start tracing events using the current configuration */
#define TRACER_STOP                       TRACER_MAGIC_NUMBER + 1  /* Stop tracing */
#define TRACER_CONFIG_DEFAULT             TRACER_MAGIC_NUMBER + 2  /* Set the tracer to the default configuration */
#define TRACER_CONFIG_MEMORY_BUFFERS      TRACER_MAGIC_NUMBER + 3  /* Set the memory buffers the daemon wants us to use */
#define TRACER_CONFIG_EVENTS              TRACER_MAGIC_NUMBER + 4  /* Trace the given events */
#define TRACER_CONFIG_DETAILS             TRACER_MAGIC_NUMBER + 5  /* Record the details of the event, or not */
#define TRACER_CONFIG_CPUID               TRACER_MAGIC_NUMBER + 6  /* Record the CPUID associated with the event */
#define TRACER_CONFIG_PID                 TRACER_MAGIC_NUMBER + 7  /* Trace only one process */
#define TRACER_CONFIG_PGRP                TRACER_MAGIC_NUMBER + 8  /* Trace only the given process group */
#define TRACER_CONFIG_GID                 TRACER_MAGIC_NUMBER + 9  /* Trace the processes of a given group of users */
#define TRACER_CONFIG_UID                 TRACER_MAGIC_NUMBER + 10 /* Trace the processes of a given user */
#define TRACER_CONFIG_SYSCALL_EIP_DEPTH   TRACER_MAGIC_NUMBER + 11 /* Set the call depth at which the EIP should be fetched on syscall */
#define TRACER_CONFIG_SYSCALL_EIP_LOWER   TRACER_MAGIC_NUMBER + 12 /* Set the lowerbound address from which EIP is recorded on syscall */
#define TRACER_CONFIG_SYSCALL_EIP_UPPER   TRACER_MAGIC_NUMBER + 13 /* Set the upperbound address from which EIP is recorded on syscall */
#define TRACER_DATA_COMITTED              TRACER_MAGIC_NUMBER + 14 /* The daemon has comitted the last trace */
#define TRACER_GET_EVENTS_LOST            TRACER_MAGIC_NUMBER + 15 /* Get the number of events lost */
#define TRACER_CREATE_USER_EVENT          TRACER_MAGIC_NUMBER + 16 /* Create a user tracable event */
#define TRACER_DESTROY_USER_EVENT         TRACER_MAGIC_NUMBER + 17 /* Destroy a user tracable event */
#define TRACER_TRACE_USER_EVENT           TRACER_MAGIC_NUMBER + 18 /* Trace a user event */
#define TRACER_SET_EVENT_MASK             TRACER_MAGIC_NUMBER + 19 /* Set the trace event mask */
#define TRACER_GET_EVENT_MASK             TRACER_MAGIC_NUMBER + 20 /* Get the trace event mask */
#define TRACER_GET_BUFFER_CONTROL         TRACER_MAGIC_NUMBER + 21 /* Get the buffer control data */
#define TRACER_CONFIG_N_MEMORY_BUFFERS    TRACER_MAGIC_NUMBER + 22 /* Set the number of memory buffers the daemon wants us to use */
#define TRACER_CONFIG_USE_LOCKING         TRACER_MAGIC_NUMBER + 23 /* Set the locking scheme to use */

/* Structures for user commands */
typedef trace_new_event tracer_create_user_event;
typedef trace_custom    tracer_trace_user_event;

#endif  /* __TRACE_DEV_COMMAND_HEADER__ */
