/*
 * MainWindow.h
 *
 * Copyright (C) 1999 Karim Yaghmour, Jean-Hugues Deschenes.
 *
 * This is distributed under GPL.
 *
 * Header for main window of trace toolkit.
 *
 * History : 
 *    JH.D., 07/08/1999, Added Toolbar to interface
 *    K.Y., 26/06/1999, Renamed file.
 *    K.Y., 02/06/1999, Initial typing.
 */

#ifndef __TRACE_TOOLKIT_MAIN_WINDOW__
#define __TRACE_TOOLKIT_MAIN_WINDOW__

/* Basic includes */
#include <EventOptions.h>
#include <EventDB.h>

/* Includes necessary for graphic front-end */
#if GTK_ENV
#include <gtk/gtk.h>
#include "OpenTrace.h"
#include "EventGraph.h"
#include "ColorSelect.h"
#include "ViewTime.h"
#include "GotoEvent.h"
#include "DumpToFile.h"

/* Strings to identify tree item data */
#define TREE_ITEM_DATA_PROC      "Process pointer"   /* Pointer to a process object */
#define TREE_ITEM_DATA_RTAI_TASK "RTAI task pointer" /* Pointer to a RTAI task object */

/* String lengths */
#define MW_DEFAULT_STRLEN        80         /* Default string length */
#define MW_LONG_STRLEN          256         /* Long strings */
#define MW_GTK_TEXT_STRLEN      100         /* Text inserted in GTK text area */
#define MW_VERSION_STRLEN        20         /* Length of LTT version */
#define MW_ABOUT_STRLEN        1000         /* Length of LTT about box text */
#define MW_TAB_STRLEN            10         /* Length of TAB */
#define MW_TREE_ITEM_STRLEN      30         /* Length of tree item string */
#define MW_TIME_HEAD_STRLEN      10         /* Header for time info in status bar */

#define HELP_CONTENTS_TEXT \
"The help files can be found under\n \
the /Help directory of the LTT source directory."

#define ABOUT_BOX_TEXT \
"Linux Trace Toolkit\n\n \
Version %s \n \
(C) 1999, 2000, 2001, 2002 \n\n \
Karim Yaghmour (karym@opersys.com)\n \
Jean-Hugues Deschenes (mr.max@vl.videotron.ca) \n \
Andy Lowe (andy_lowe@mvista.com) \n \
Bob Montgomery (bob_montgomery@hp.com)\n \
Rocky Craig (rocky_craig@hp.com) \n \
Andrea Cisternino (andrea.cisternino@st.com) \n \
Frank Rowand (frowand@mvista.com) \n \
Takuzo O\'Hara (takuzo@sm.sony.co.jp) \n \
Jrg Hermann (joerg.hermann@multilink.de) \n \
Portions contributed by T.Halloran: (C) IBM corp. \n\n \
For up to date information and news about this software, \n \
see the project\'s website at: \n \
http://www.opersys.com/LTT \n\n \
This software is distributed under the terms of the GPL, \n \
see the file entitled \"COPYING\" for further detail. \n"

/* Structure describing a trace main window */
typedef struct _mainWindow
{
  /* Links to important structures */
  struct _systemView*  SystemView;    /* System view displayed in this window */

  /* Main widgets */
  GtkWidget*      MWindow;            /* Main window */
  GtkWidget*      MVBox;              /* Main VBox */
  GtkWidget*      MMenu;              /* Main menu */
  GtkWidget*      MToolBar;           /* Toolbar */
  GtkWidget*      MNotebook;          /* Main Notebook */
  GtkWidget*      MStatusBarBox;      /* HBox containing the status bars */
  GtkAccelGroup*  MAccelerator;       /* Accelerator */

  /* Menu items on main menu */
  GtkWidget*    FileMenuTitle;      /* File menu */
  GtkWidget*    EditMenuTitle;      /* Edit menu */
  GtkWidget*    ToolsMenuTitle;     /* Tools menu */
  GtkWidget*    OptionsMenuTitle;   /* Options menu */
  GtkWidget*    TraceMenuTitle;     /* Trace menu */
  GtkWidget*    HelpMenuTitle;      /* Help menu */

  /* Submenus */
  GtkWidget*    FileMenu;           /* File menu */
  GtkWidget*    EditMenu;           /* Edit menu */
  GtkWidget*    ToolsMenu;          /* Tools menu */
  GtkWidget*    OptionsMenu;        /* Options menu */
  GtkWidget*    TraceMenu;          /* Trace menu */
  GtkWidget*    HelpMenu;           /* Help menu */

  /* File menu items */
  GtkWidget*    OpenTrace;          /* Open a trace */
  GtkWidget*    CloseTrace;         /* Close current trace trace */
  GtkWidget*    DumpToFile;         /* Dump trace to file */
  GtkWidget*    FileMenuSeparator1; /* Separator */
  GtkWidget*    Quit;               /* Quit trace session */

  /* Edit menu items */

  /* Tools menu items */
  GtkWidget*    ZoomIn;             /* Zoom in */
  GtkWidget*    ZoomOut;            /* Zoom out */
  GtkWidget*    ToolMenuSeparator1; /* Separator */
  GtkWidget*    ShowHorizon;        /* Show the horizon lines */
  GtkWidget*    ToolMenuSeparator2; /* Separator */
  GtkWidget*    ToolGoToEvent;      /* Go to event... */
  GtkWidget*    ToolViewTimeFrame;  /* View time frame */

  /* Options menu items */
  GtkWidget*    Colors;             /* Display colors */
  GtkWidget*    OptMenuSeparator1;  /* Separator */
  GtkWidget*    ConfigureDaemon;    /* Configure trace daemon */

  /* Help menu items */
  GtkWidget*    Contents;           /* Content of help */
  GtkWidget*    HelpMenuSeparator1; /* Separator */
  GtkWidget*    About;              /* About trace toolkit */

  /* Toolbar Buttons */
  GtkWidget*    tlbOpenTrace;       /* Open a trace */
  GtkWidget*    tlbCloseTrace;      /* Close current trace */
  GtkWidget*    tlbDumpFile;        /* Dump to file */
  GtkWidget*    tlbZoomIn;          /* Zoom in */
  GtkWidget*    tlbZoomOut;         /* Zoom out */
  GtkWidget*    tlbGotoEvent;       /* Go to event */
  GtkWidget*    tlbShowHorizon;     /* Show horizon */
  GtkWidget*	tlbHideIconText;    /* Hide icon text */
  GtkWidget*	tlbHideSysCalls;    /* Hide system calls */
  GtkWidget*	tlbHideIRQs;        /* Hide IRQs */
  GtkWidget*	tlbHideTraps;       /* Hide Traps */
  GtkWidget*	tlbHideSoftIRQs;    /* Hide soft IRQs */
  GtkWidget*	tlbHideSchedChange; /* Hide scheduling changes */
  GtkWidget*	tlbHideKernelTimer; /* Hide kernel timer */
  GtkWidget*	tlbSlowH;           /* Draw horizontal lines slowly */
  GtkWidget*	tlbSlowV;           /* Draw vertical lines slowly */
  GtkWidget*	tlbSlowI;           /* Draw icons slowly */

  /* The Notebook thumbnails */
  GtkWidget*    Graph;              /* Graph view of trace */
  GtkWidget*    Process;            /* Per-process specific information */
  GtkWidget*    RawTrace;           /* Raw event trace */

  /* Graph thumbnail */
  GtkWidget*    GTHBox;             /* Horizontal box */
  eventGraph*   GTEventGraph;       /* The event graph*/

  /* Process thumbnail */
  GtkWidget*    PTHPanned;          /* Horizontal panned widget */
  GtkWidget*    PTScrolledTree;     /* Window to contain scrollable tree */
  GtkWidget*    PTProcessTree;      /* Process tree */
  GtkWidget*    PTScrolledText;     /* Window to contain scrollable text */
  GtkWidget*    PTProcessText;      /* Text describing process */
  GdkFont*      PTTextFont;         /* Font used to print process characteristics */

  /* Raw event trace */
#define RTCLIST_NB_COLUMNS 6
#define RTCLIST_NB_ROWS    50
#if 0
  gchar*        RTCListTitles[RTCLIST_NB_COLUMNS] = {"CPU-ID",
                                                     "Event",
						     "Seconds",
						     "Microseconds",
						     "PID",
						     "Entry Length",
						     "Event Description"};
#endif
  GtkWidget*     RTHBox;    /* Columned list horizontal packing box */
  GtkWidget*     RTVScroll; /* The list's scrollbar */
  GtkAdjustment* RTVAdjust; /* The scrollbar's adjustment */
  GtkWidget*     RTCList;   /* Columned list */
  

  /* Event graph popup */
  GtkWidget*    EventGraphPopup;    /* The popup menu associated to the event graph */
  GtkWidget*    EventGotoProcess;   /* Goto process analysis */
  GtkWidget*    EventViewRawEvent;  /* Go to raw event list */

  /* Raw event popup */
  GtkWidget*    RawEventPopup;      /* The popup menu associated to the raw event list */
  GtkWidget*    RawViewEvent;       /* View event in graph */
  GtkWidget*    RawGotoProcess;     /* Goto process analysis */

  /* The status bar components */
  GtkWidget*    MainSBar;           /* Main status bar */
  GtkWidget*    BegTimeSBar;        /* Status bar displaying the time of the first event displayed */
  GtkWidget*    EndTimeSBar;        /* Status bar displayint the time of the last event displayed */

  /* Status bar information */
  guint         MainSBarContextID;    /* Context ID of main status bar */
  guint         BegTimeSBarContextID; /* Context ID of BegTime status bar */
  guint         EndTimeSBarContextID; /* Context ID of EndTime status bar */
 
  /* Child windows */
  openTraceWindow*     OpenTraceWindow;     /* Window used to get a prof and a proc file */
  colorSelectWindow*   ColorSelectWindow;   /* Window used to configure colors and linetypes */
  viewTimeFrameWindow* ViewTimeFrameWindow; /* Window used to select a time frame to be viewed */
  gotoEventWindow*     GotoEventWindow;     /* Window used to search for an event description */
  dumpToFileWindow*    DumpToFileWindow;    /* Window used to set file dumping options */
  GtkWidget*           HelpContents;        /* Window used to display help contents */
  GtkWidget*           AboutBox;            /* Window used for about information */

  /* Last selected event, required by context menus */
  int           EventSelected;
  event         LastSelectedEvent;

} mainWindow;

/* Structure linking a trace toolkit window with a system description */
typedef struct _systemView
{
  db*                 EventDB;           /* Database of events */
  systemInfo*         System;            /* System description */
  options*            Options;           /* The system options */
  mainWindow*         Window;            /* Window where information is displayed */
  struct _systemView* Next;              /* Next system view in list */
} systemView;

/* The trace window functions */
void        WDConnectSignals
                 (systemView*  /* The system view who's signals are to be connected*/);

void        WDShowMainWindow
                 (systemView*  /* Main window to be shown */);

void        WDFillEventList
                 (GtkWidget*  /* The CList to be filled */,
		  db*         /* The event database */,
		  systemInfo* /* The system */,
		  event*      /* The first event to display in the raw event list */,
		  event*      /* Last selected event, if any */);

mainWindow* WDCreateMainWindow
                 (systemView*  /* The system view to be displayed in the window */);

void        WDDisplayTrace
                 (systemView*  /* The system view to be displayed */);

systemView* WDCreateSystemView
                 (systemInfo*  /* System description */,
		  db*          /* Event database */,
		  options*     /* The options for this view */);

void        WDDestroySystemView
                 (systemView*  /* The system view to destroy*/);

void        WDStatusBarDisplay
                 (gpointer     /* Main window */,
                  gchar*       /* String to be displayed */);

void        WDTimeSBarDisplay
                 (gpointer     /* Main window */,
		  gdouble      /* Start time */,
		  gdouble      /* End time */);

void        WDSetMenusSensitivity
                 (systemView*  /* The System view containing the menus to set */,
		  gboolean     /* Sensitivity value to be set */,
		  gboolean     /* Minimal sensitivity value to be set */);

void        WDToolBarPopulate
                 (systemView*  /* The system view to be displayed */);

#endif /* GTK_ENV */
#endif /* __TRACE_TOOLKIT_MAIN_WINDOW__ */
